Imports System.ComponentModel
' Enumration des images.
Public Enum AnimFrame
    Lemon1
    Lemon2
    Lemon3
    AlmostDead
    Dead
End Enum

' Marquer les vnements et les proprits par dfaut pour ce contrle.
<DefaultEvent("BlewUp"), DefaultProperty("Anim")> _
Public Class CarControl
    Inherits System.Windows.Forms.UserControl

    ' Donnes d'tat.
    Private currFrame As AnimFrame = AnimFrame.Lemon1
    Private currMaxFrame As AnimFrame = AnimFrame.Lemon3
    Private IsAnim As Boolean
    Private currSp As Integer
    Private WithEvents pictureBox As System.Windows.Forms.pictureBox
    Private maxSp As Integer = 100
    Private WithEvents animTimer As System.Windows.Forms.Timer
    Private carPetName As String = "PasDeNom"
    Private bottomRect As RectangleF = New RectangleF()
    Friend WithEvents ImageList1 As System.Windows.Forms.ImageList
    Private txtPaneColor As Color

    ' Evnements voiture.
    <Category("Car Configuration"), _
    Description("Envoy lorsque la voiture approche de sa vitesse limite.")> _
    Public Event AboutToBlow()

    <Category("Car Configuration"), _
    Description("Envoy lorsque votre voiture rend l'me.")> _
    Public Event BlewUp()

#Region " Windows Form Designer generated code "

    Public Sub New()
        MyBase.New()

        'Cet appel est requis par le concepteur Windows Form.
        InitializeComponent()

        ' Dfinir la couleur.
        txtPaneColor = Color.GhostWhite

        ' Prparer la boite.
        StretchBox()
    End Sub

    'UserControl1 surcharge la mthode dispose pour nettoyer la liste des composants.
    Protected Overloads Overrides Sub Dispose(ByVal disposing As Boolean)
        If disposing Then
            If Not (components Is Nothing) Then
                components.Dispose()
            End If
        End If
        MyBase.Dispose(disposing)
    End Sub
    Private components As System.ComponentModel.IContainer

    'Requis par le Concepteur Windows Form

    'NOTE: La procdure suivante est requise par le Concepteur Windows Form
    'Elle peut tre modifie en utilisant le Concepteur Windows Form.  
    'Ne pas la modifier en utilisant le Concepteur Windows Form.
    <System.Diagnostics.DebuggerStepThrough()> Private Sub InitializeComponent()
        Me.components = New System.ComponentModel.Container()
        Dim resources As System.Resources.ResourceManager = New System.Resources.ResourceManager(GetType(CarControl))
        Me.animTimer = New System.Windows.Forms.Timer(Me.components)
        Me.ImageList1 = New System.Windows.Forms.ImageList(Me.components)
        Me.pictureBox = New System.Windows.Forms.PictureBox()
        Me.SuspendLayout()
        '
        'animTimer
        '
        Me.animTimer.Interval = 200
        '
        'ImageList1
        '
        Me.ImageList1.ColorDepth = System.Windows.Forms.ColorDepth.Depth8Bit
        Me.ImageList1.ImageSize = New System.Drawing.Size(47, 47)
        Me.ImageList1.ImageStream = CType(resources.GetObject("ImageList1.ImageStream"), System.Windows.Forms.ImageListStreamer)
        Me.ImageList1.TransparentColor = System.Drawing.Color.Transparent
        '
        'pictureBox
        '
        Me.pictureBox.Location = New System.Drawing.Point(24, 40)
        Me.pictureBox.Name = "pictureBox"
        Me.pictureBox.Size = New System.Drawing.Size(102, 52)
        Me.pictureBox.SizeMode = System.Windows.Forms.PictureBoxSizeMode.StretchImage
        Me.pictureBox.TabIndex = 0
        Me.pictureBox.TabStop = False
        '
        'CarControl
        '
        Me.Controls.AddRange(New System.Windows.Forms.Control() {Me.pictureBox})
        Me.Name = "CarControl"
        Me.ResumeLayout(False)

    End Sub

#End Region

    Private Sub animTimer_Tick(ByVal sender As Object, ByVal e As System.EventArgs) Handles animTimer.Tick
        If (IsAnim) Then
            ' Ici nous chargeons depuis l'objet ImageList
            ' Ces objets sont imbriqus dans l'assembly.
            pictureBox.Image = ImageList1.Images(CType(currFrame, Integer))
        End If
        ' Prparer les frames.
        Dim s As String = [Enum].Format(GetType(AnimFrame), currFrame, "D")
        Dim i As Integer = Integer.Parse(s)
        Dim nextFrame As Integer = i + 1
        currFrame = CType(nextFrame, AnimFrame)

        If (currFrame > currMaxFrame) Then
            currFrame = AnimFrame.Lemon1
        End If
    End Sub

    Private Sub CarControl_Paint(ByVal sender As Object, ByVal e As System.Windows.Forms.PaintEventArgs) Handles MyBase.Paint
        ' Afficher la valeur de petname dans le bas du contrle.
        Dim g As Graphics = e.Graphics
        g.FillRectangle(New SolidBrush(txtPaneColor), bottomRect)
        g.DrawString(PetName, New Font("Times New Roman", 15), Brushes.Black, bottomRect)
    End Sub

    Private Sub CarControl_Resize(ByVal sender As Object, ByVal e As System.EventArgs) Handles MyBase.Resize
        StretchBox()
        Invalidate()
    End Sub

    ' Contrle la vitesse actuelle.
    <Category("Car Configuration"), _
    Description("Configure la vitesse de la voiture"), _
    DefaultValue(50)> _
      Public Property Speed() As Integer
        Get
            Return currSp
        End Get
        Set(ByVal Value As Integer)
            currSp = Value
            currFrame = currMaxFrame
            ' Prte  exploser ?
            If ((maxSp - currSp) <= 10) Then
                RaiseEvent AboutToBlow()
                currMaxFrame = AnimFrame.AlmostDead
            End If
            ' Vitesse limite dpasse ?
            If (currSp >= maxSp) Then
                currSp = maxSp
                RaiseEvent BlewUp()
                currMaxFrame = AnimFrame.Dead
            End If
        End Set
    End Property

    ' Contrler le timer de la fentre.
    <Category("Car Configuration"), _
    Description("Voulez vous une animation?"), _
    DefaultValue(False)> _
    Public Property Anim() As Boolean
        Get
            Return IsAnim
        End Get
        Set(ByVal Value As Boolean)
            IsAnim = Value
            animTimer.Enabled = IsAnim
        End Set
    End Property

    ' Configurer le surnom de la voiture.
    <Category("Car Configuration"), _
    Description("Surnom de la voiture"), _
    DefaultValue("PasDeNom")> _
    Public Property PetName() As String
        Get
            Return carPetName
        End Get
        Set(ByVal Value As String)
            carPetName = Value
            Invalidate()
        End Set
    End Property

    ' Configurer la couleur du tableau de texte.
    <Category("Car Configuration"), _
    Description("Dfinie la couleur de la zone de texte")> _
    Public Property TextPaneColor() As Color
        Get
            Return txtPaneColor
        End Get
        Set(ByVal Value As Color)
            txtPaneColor = Value
            Invalidate()
        End Set
    End Property

    Private Sub StretchBox()
        ' Configurer la bote d'image.
        pictureBox.Top = 0
        pictureBox.Left = 0
        pictureBox.Height = Me.Height - 50
        pictureBox.Width = Me.Width
        pictureBox.Image = ImageList1.Images(CType(AnimFrame.Lemon1, Integer))

        ' Dfinir la taille du rectangle du bas.
        bottomRect.X = 0
        bottomRect.Y = Me.Height - 50
        bottomRect.Height = Me.Height - pictureBox.Height
        bottomRect.Width = Me.Width
    End Sub
End Class
